% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d.R
\name{value_3L}
\alias{value_3L}
\title{Function to value EQ-5D-3L columns to index values for any country and group
 by gender and age}
\usage{
value_3L(
  eq5dresponse_data,
  mo,
  sc,
  ua,
  pd,
  ad,
  country,
  method,
  groupby,
  agelimit
)
}
\arguments{
\item{eq5dresponse_data}{the data containing eq5d responses}

\item{mo}{column name for EQ-5D-3L mobility}

\item{sc}{column name for response for EQ-5D-3L self care}

\item{ua}{column name for response for EQ-5D-3L usual activities}

\item{pd}{column name for response for EQ-5D-3L pain/discomfort}

\item{ad}{column name for response for EQ-5D-3L anxiety/depression}

\item{country}{country of interest, by default is UK, if groupby has to 
specify the country should be specified}

\item{method}{Either "TTO" or "VAS"}

\item{groupby}{male or female -grouping by gender, default NULL}

\item{agelimit}{vector of ages to show upper and lower limits}
}
\value{
the descriptive statistics of index values, frequency table and 
the modified data where the last column will be the index values
data<-data.frame(age=c(10,20),sex=c("M","F"),mo=c(1,2),sc=c(1,2),ua=c(3,4),
pd=c(3,1),ad=c(3,1))
value_3L(data, "mo", "sc","ua", "pd", "ad","UK","TTO",NULL,c(10,70))
}
\description{
Main function to value EQ-5D-5L descriptive system to 5L 
index values.
}
