% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ps.R
\name{ps}
\alias{ps}
\title{Pruned Set for multi-label Classification}
\usage{
ps(
  mdata,
  base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  p = 3,
  strategy = c("A", "B"),
  b = 2,
  ...,
  cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{p}{Number of instances to prune. All labelsets that occurs p times or
less in the training data is removed. (Default: 3)}

\item{strategy}{The strategy  (A or B) for processing infrequent labelsets.
(Default: A).}

\item{b}{The number used by the strategy for processing infrequent labelsets.}

\item{...}{Others arguments passed to the base algorithm for all subproblems.}

\item{cores}{Not used}

\item{seed}{An optional integer used to set the seed. (Default:
\code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{PSmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{model}{A LP model contained only the most common labelsets.}
  }
}
\description{
Create a Pruned Set model for multilabel classification.
}
\details{
Pruned Set (PS) is a multi-class transformation that remove the less common
classes to predict multi-label data.
}
\examples{
model <- ps(toyml, "RANDOM")
pred <- predict(model, toyml)

\donttest{
##Change default configurations
model <- ps(toyml, "RF", p=4, strategy="B", b=1)
}
}
\references{
Read, J., Pfahringer, B., & Holmes, G. (2008). Multi-label classification
  using ensembles of pruned sets. In Proceedings - IEEE International
  Conference on Data Mining, ICDM (pp. 995–1000).
}
\seealso{
Other Transformation methods: 
\code{\link{brplus}()},
\code{\link{br}()},
\code{\link{cc}()},
\code{\link{clr}()},
\code{\link{dbr}()},
\code{\link{ebr}()},
\code{\link{ecc}()},
\code{\link{eps}()},
\code{\link{esl}()},
\code{\link{homer}()},
\code{\link{lift}()},
\code{\link{lp}()},
\code{\link{mbr}()},
\code{\link{ns}()},
\code{\link{ppt}()},
\code{\link{prudent}()},
\code{\link{rakel}()},
\code{\link{rdbr}()},
\code{\link{rpc}()}

Other Powerset: 
\code{\link{eps}()},
\code{\link{lp}()},
\code{\link{ppt}()},
\code{\link{rakel}()}
}
\concept{Powerset}
\concept{Transformation methods}
