% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calc_cumsum}
\alias{calc_cumsum}
\title{Calculate cumulative summation of vector}
\usage{
calc_cumsum(x, na.fill = FALSE)
}
\arguments{
\item{x}{A numeric.}

\item{na.fill}{A logical. Impute forward for NA values.}
}
\value{
A vector of the same length and type as x.
}
\description{
Calculate the cumulative summation of a numeric vector with
revised NA handling compared to `base::cumsum()`.
}
\examples{
x <- 1:10
x[3:4] <- NA

# Calculate cumsum & replace NA values
calc_cumsum(x, na.fill = TRUE)
}
