% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{paste_efs}
\alias{paste_efs}
\title{Paste event-free survival}
\usage{
paste_efs(x, times, percent.sign = TRUE, digits = 1)
}
\arguments{
\item{x}{A \code{\link[survival]{survfit}} object. The survival model.}

\item{times}{A numeric. Indicates time-points of interest. Units are whatever
was used to create the survival fit.}

\item{percent.sign}{A logical. Indicates percent sign should be printed
for frequencies.}

\item{digits}{Integer. Number of digits to round to.}
}
\value{
A character vector of event free survival(s).
}
\description{
Creates a human-readable event-free-survival from a survfit object
and a specified time point.
}
\examples{
library(survival)

fit <- survfit(Surv(time, status) ~ 1, data = diabetic)
paste_efs(fit, c(1, 3, 5))
}
