% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_processing.R
\name{plot_TTS}
\alias{plot_TTS}
\title{Plot time to suppression distribution}
\usage{
plot_TTS(TTS_output, textsize = 9, bins = 20)
}
\arguments{
\item{TTS_output}{output from estimating time to suppression (TTS) values using get_TTS()..}

\item{textsize}{numeric value for base text size on ggplot. Default is 9.}

\item{bins}{numeric value indicating the number of bins for the histogram. Default is 20.}
}
\description{
This function plots a histogram of the time to suppression estimates.
}
\examples{

set.seed(1234567)

simulated_data <- simulate_data(nsubjects = 20)

TTSestimates <- get_TTS(data = simulated_data, parametric = FALSE)

plot_TTS(TTSestimates, bins = 5)

}
