% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_fns_triphasic.R
\name{get_error_triphasic}
\alias{get_error_triphasic}
\title{Evaluate error metric between data and model prediction}
\usage{
get_error_triphasic(params, param_names, free_param_index, data,
  inv_param_transform_fn)
}
\arguments{
\item{params}{named vector of the parameters from which the model prediction should be generated.}

\item{param_names}{names of parameter vector.}

\item{free_param_index}{logical TRUE/FALSE vector indicating whether the parameters A, delta, A_b, delta_b, B, gamma are to be recovered. This should be c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE) for the triphasic model.}

\item{data}{dataframe with columns for the subject's viral load measurements ('vl'), and timing of sampling ('time').}

\item{inv_param_transform_fn}{list of transformation functions to be used when back-transforming the transformed parameters. Should be the inverse of the forward transformation functions. Defaults to exponential.}
}
\description{
For a given parameter set, this function computes the predicted viral load curve and evaluates the error metric between the prediction and observed data (to be passed to optim).
}
