% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{url_modify}
\alias{url_modify}
\alias{set_scheme}
\alias{set_user}
\alias{set_password}
\alias{set_host}
\alias{set_port}
\alias{set_path}
\alias{set_query}
\alias{set_fragment}
\title{Modifies a URL string by updating its components.}
\usage{
url_modify(
  url,
  scheme = NULL,
  user = NULL,
  password = NULL,
  host = NULL,
  port = NULL,
  path = NULL,
  query = NULL,
  fragment = NULL
)

set_scheme(url, scheme)

set_user(url, user)

set_password(url, password)

set_host(url, host)

set_port(url, port)

set_path(url, path)

set_query(url, query)

set_fragment(url, fragment)
}
\arguments{
\item{url}{A character string representing the original URL.}

\item{scheme}{A character string for the new scheme (e.g., "http" or "https") or \code{NULL} to keep it unchanged.}

\item{user}{A character string for the username or \code{NULL} to keep it unchanged.}

\item{password}{A character string for the new password or \code{NULL} to keep it unchanged.}

\item{host}{A character string for the new host or \code{NULL} to keep it unchanged.}

\item{port}{A character string for the new port or \code{NULL} to keep it unchanged.}

\item{path}{A character string for the new path or \code{NULL} to keep it unchanged.}

\item{query}{A list or character of new query parameters or \code{NULL} to keep it unchanged.}

\item{fragment}{A character string for the new fragment or \code{NULL} to keep it unchanged.}
}
\value{
A character string representing the modified URL.
}
\description{
This function modifies a URL string by updating its components such as scheme, user, password, host, port, query, raw query, and fragment.
If any of these components are not provided (i.e., \code{NULL}), the existing components of the URL are retained.
}
\examples{
library(urlparse)

# Example 1: Modify the scheme and host of a URL
url_modify(
  "https://user:pass@host.com/path?query#fragment",
  scheme = "http",
  host = "example.com"
)

# Example 2: Add a query parameter to a URL
url_modify(
  "https://host.com/path", query = list(key1 = "value1", key2 = "value2")
)

# Example 3: Change the fragment of a URL
url_modify("https://host.com/path#old_fragment", fragment = "new_fragment")

}
