library(fracdiff)
set.seed(123456)
# ARFIMA(0.4,0.4,0.0)
y1 <- fracdiff.sim(n=1000, ar=0.4, ma=0.0, d=0.4)
# ARIMA(0.4,0.0,0.0)
y2 <- arima.sim(model=list(ar=0.4), n=1000)
# Graphics
op <- par(no.readonly=TRUE)
layout(matrix(1:6, 3, 2, byrow=FALSE))
plot.ts(y1$series,
        main='Time series plot of long memory',
        ylab='')
acf(y1$series, lag.max=100,
    main='Autocorrelations of long memory')
spectrum(y1$series,
         main='Spectral density of long memory')
plot.ts(y2,
        main='Time series plot of short memory', ylab='')
acf(y2, lag.max=100,
    main='Autocorrelations of short memory')
spectrum(y2, main='Spectral density of short memory')
par(op)
