% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irr_stats.R
\name{irr_stats}
\alias{irr_stats}
\title{irr_stats}
\usage{
irr_stats(
  object_name,
  rater_column,
  subject_column,
  coding_column,
  round_digits = 2,
  stats_to_include = c("Percentage agreement", "Krippendorf's Alpha")
)
}
\arguments{
\item{object_name}{A dataframe or tibble containing raters' codings. Each row should contain the assigned coding
from a given rater-subject.}

\item{rater_column}{The name of the column containing the raters' names as a string.}

\item{subject_column}{The name of the column containing the names of the subjects being coded as a string.}

\item{coding_column}{The name of the column containing the codings assigned by the raters as a string.}

\item{round_digits}{The number of decimals to round the IRR values by. The default is 2.}

\item{stats_to_include}{The IRR statistics to include in the output. Currently only supports percent agreement and Krippendorf's Alpha. See the documentation of the \href{https://cran.r-project.org/package=irr}{irr package} for more information about specific IRR statistics.}
}
\value{
A tibble containing the IRR statistic, the statistic's value, and the number of subjects used to calculate the statistic.
}
\description{
\code{irr_stats} calculates a variety of IRR statistics.
}
\examples{
# Return IRR statistics for the diagnoses dataset:
irr_stats(diagnoses,
          rater_column = 'rater_id',
          subject_column = 'patient_id',
          coding_column = 'diagnosis')

# And IRR statistics for the anxiety dataset:
irr_stats(anxiety,
          rater_column = 'rater_id',
          subject_column = 'subject_id',
          coding_column = 'anxiety_level')

}
\author{
Benjamin Goehring <bengoehr@umich.edu>
}
