% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_cells}
\alias{merge_cells}
\alias{merge_rows}
\alias{merge_cols}
\title{Merge cell values into a single cell by rows or columns}
\usage{
merge_rows(cells, rows, values, collapse = " ")

merge_cols(cells, cols, values, collapse = " ")
}
\arguments{
\item{cells}{Data frame. The cells of a pivot table, usually the output of
\code{\link[=as_cells]{as_cells()}} or \code{\link[tidyxl:xlsx_cells]{tidyxl::xlsx_cells()}}, or of a subsequent operation on
those outputs.}

\item{rows}{The numbers of the rows to be merged.}

\item{values}{The column of \code{cells} to use as the values of each cell to be
merged.  Given as a bare variable name.}

\item{collapse}{A character string to separate the values of each cell.}

\item{cols}{The numbers of the columns to be merged.}
}
\value{
A data frame
}
\description{
When a single column header is split across cells, merge the
cells with \code{\link[=merge_rows]{merge_rows()}} or \code{\link[=merge_cols]{merge_cols()}}.  E.g. if a column header "Mean
GDP" is split over two cells, where the top cell has the value "Mean" and the
bottom cell has the value "GDP", then \code{\link[=merge_rows]{merge_rows()}} will combine them into a
single cell with the value "Mean GDP".

\code{\link[=merge_rows]{merge_rows()}} keeps the top cell, and \code{\link[=merge_cols]{merge_cols()}} keeps the left-most
cell.  When there are several columns of headers, \code{\link[=merge_rows]{merge_rows()}} aligns the
output cells so that they are all in the same row, and similarly
\code{\link[=merge_cols]{merge_cols()}} aligns to the same column.

These functions apply only to cells with character values because it doesn't
make sense to concatenate non-character values.  Convert cell values to
characters first if you need to merge non-character cells.
}
\examples{
 x <- tibble::tribble(
~row, ~col, ~data_type,     ~chr,
   1,    1,      "chr",   "Katy",
   2,    1,      "chr",  "Perry",
   3,    1,      "chr",      "a",
   4,    1,      "chr",      "b",
   5,    1,      "chr",      "c",
   2,    2,      "chr",  "Adele",
   3,    2,      "chr",      "d",
   4,    2,      "chr",      "e",
   5,    2,      "chr",      "f",
   1,    3,      "chr", "Ariana",
   2,    3,      "chr", "Grande",
   3,    3,      "chr",      "g",
   4,    3,      "chr",      "h",
   5,    3,      "chr",      "i"
)
rectify(x)
y <- merge_rows(x, 1:2, chr)
rectify(y)
z <- merge_cols(x, 1:2, chr)
rectify(z)
}
