% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volumes.R
\name{volume_simplex}
\alias{volume_simplex}
\title{Simplex volume}
\usage{
volume_simplex(simplex)
}
\arguments{
\item{simplex}{a \code{(d+1)} times \code{d} matrix giving the vertices of
the simplex (rows)}
}
\value{
The volume of the simplex.
}
\description{
Volume of a simplex (arbitrary dimension).
}
\examples{
set.seed(666)
simplex <- matrix(rnorm(4*3), nrow=4, ncol=3)
volume_simplex(simplex)
volume_tetrahedron(simplex[1,], simplex[2,], simplex[3,], simplex[4,])
}
