% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifed.R
\name{unifed}
\alias{unifed}
\alias{quasiunifed}
\title{Family object for the unifed distribution}
\usage{
unifed(link = "logit", ...)

quasiunifed(link = "logit", ...)
}
\arguments{
\item{link}{a specification for the model link function.  This can
be a name/expression, a literal character string, a length-one
character vector or an object of class ‘"link-glm"’ (such as
generated by ‘make.link’) provided it is not specified via one
of the standard names. The \code{unifed} family accepts the
links (as names) 'logit', 'probit', 'cloglog' and 'cauchit'.}

\item{...}{Optional \code{tol} and \code{maxit} arguments for
\code{\link{unifed.unit.deviance}}.}
}
\value{
\code{unifed} returns a family object for using the unifed
    distribution with the \code{glm} function.

The \code{quasiunifed} family differs from the
    \code{unifed} only in that the dispersion parameter is not
    fixed to one.
}
\description{
Family object for the unifed distribution
}
\references{
{

Jørgensen, Bent (1992). The Theory of Exponential Dispersion Models and Analysis  of  Deviance.
Instituto de Matemática Pura e Aplicada, (IMPA), Brazil.

}

{

Wedderburn, R. W. M. (1974). Quasi-likelihood functions, generalized linear models, and the Gauss—Newton method. Biometrika. \bold{61} (3): 439–447.

McCullagh, Peter; Nelder, John (1989). Generalized Linear Models (second ed.). London: Chapman and Hall.

}
}
