% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lund.R
\docType{data}
\name{lund_3}
\alias{lund_3}
\title{Darker pastel colours of the University of Lund, Sweden}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on \href{https://www.lu.se}{LU}'s staff guidelines on 
\href{https://www.staff.lu.se/support-and-tools/communication-and-graphic-profile/graphic-profile-and-logotype/colours}{Colour} (HTML).
}
\usage{
lund_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{lund_3} provides darker tints of the five pastel colours  
of the \href{https://www.lu.se}{Lund University}, Sweden.
}
\details{
See \code{\link{lund_2}} for the pastel colours of Lund University. 

\code{lund_3} is based on HEX color definitions.
}
\examples{
lund_3
unikn::seecol(lund_3, main = "Darker pastel colours of Lund University, Sweden")

}
\seealso{
\code{\link{lund_1}} for profile colours of Lund University; 
\code{\link{lund_2}} for pastel colours of Lund University; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Swedish university color palettes: 
\code{\link{gothenburg}},
\code{\link{lund_1}},
\code{\link{lund_2}},
\code{\link{stockholm_1}},
\code{\link{stockholm_2}},
\code{\link{uppsala}}
}
\author{
\strong{unicol}, 2023-10-12.
}
\concept{Swedish university color palettes}
\keyword{datasets}
