% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Concordia.R
\docType{data}
\name{concordia_3}
\alias{concordia_3}
\title{Background tints of Concordia University, Canada}
\format{
An object of class \code{character} of length 9.
}
\source{
Color definitions are based on \href{https://www.concordia.ca}{Concordia}'s 
\href{https://www.concordia.ca/web/design/ui-kit-style-guide-accessibility/web-palette-new.html}{web colour palette}.
}
\usage{
concordia_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{concordia_3} provides the nine background tints  
of \href{https://www.concordia.ca}{Concordia University}, Canada.
}
\details{
The 9 background tints are
\code{"Burgundy 1"} (defined as HEX #E9D3D7),
\code{"Magenta 1"} (defined as HEX #FACDE3), 
\code{"Orange 1"} (defined as HEX #f9cdc3),
\code{"Mauve 1"} (defined as HEX #dcd6e8),
\code{"Dark blue 1"} (defined as HEX #B2C5DA),
\code{"Blue 1"} (defined as HEX #d3e1e9),
\code{"Turquoise 1"} (defined as HEX #CCE3E4),
\code{"Green 1"} (defined as HEX #dfeccf), and
\code{"Gold 1"} (defined as HEX #e9e3d3).

\code{concordia_3} uses the HEX color definitions.


The background tint colours of \code{concordia_3} 
can be used to create blocks of background colour on a web page 
to separate and draw attention to content.
}
\examples{
concordia_3
unikn::seecol(concordia_3, main = "Background tints of Concordia University")  # view palette

}
\seealso{
\code{\link{concordia_1}} for primary colours of Concordia University;
\code{\link{concordia_2}} for secondary colours of Concordia University;
\code{\link{concordia_4}} for neutral colours of Concordia University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-26.
}
\concept{Canadian university color palettes}
\keyword{datasets}
