% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Limerick.R
\docType{data}
\name{limerick_1}
\alias{limerick_1}
\title{Primary colours of the University of Limerick, Ireland}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on 
\href{https://www.ul.ie/media/31805/download?inline}{ULimerck's brand guidelines (PDF)}.
}
\usage{
limerick_1
}
\value{
A names vector of colours (HEX/HTML codes of type character).
}
\description{
\code{limerick_1} provides the four primary colours
of the \href{https://www.ul.ie}{University of Limerick}, Ireland.
}
\details{
The 4 primary colours are
\code{"UL green"} (defined as HEX #005335), 
\code{"UL modern green"} (defined as HEX #00B140), 
\code{"UL heritage green"} (defined as HEX #003726), 
\code{"white"} (defined as HEX #FFFFFF). 

\code{limerick_1} uses the HEX colour definitions.
}
\examples{
limerick_1
unikn::seecol(limerick_1, main= "University of Limerick 1") # view colour palette.

}
\seealso{
\code{\link{limerick_2}} for secondary colours of the University of Limerick;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{UCC_1}},
\code{\link{UCC_2}},
\code{\link{UCD}},
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{limerick_2}},
\code{\link{maynooth}},
\code{\link{trinity_1}},
\code{\link{trinity_2}}
}
\author{
\strong{unicol}, 2023-07-16.
}
\concept{Irish university color palettes}
\keyword{datasets}
