% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dartmouth.R
\docType{data}
\name{dartmouth_3}
\alias{dartmouth_3}
\title{Tertiary colors of Dartmouth College, USA}
\format{
An object of class \code{character} of length 10.
}
\source{
Color definitions are based on 
\href{https://communications.dartmouth.edu/visual-identity/design-elements/color-palette}{Dartmouth's visual identity guide}.
}
\usage{
dartmouth_3
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{dartmouth_3} provides the ten tertiary colors
of the \href{https://home.dartmouth.edu}{Dartmouth College}, USA.
}
\details{
The 10 tertiary colors are 
\code{"autumn_brown"} (defined as HEX #643c20), 
\code{"bonfire_red"} (defined as HEX #9d162e), 
\code{"tuck_orange"} (defined as HEX #e32d1c), 
\code{"summer_yellow"} (defined as HEX #f5dc96), 
\code{"spring_green"} (defined as HEX #c4dd88), 
\code{"rich_spring_green"} (defined as HEX #a5d75f), 
\code{"river_navy"} (defined as HEX #003c73), 
\code{"river_blue"} (defined as HEX #267aba), 
\code{"web_violet"} (defined as HEX #8a6996), and 
\code{"bonfire_orange"} (defined as HEX #ffa00f). 

\code{dartmouth_3} uses the HEX color definitions.
}
\examples{
dartmouth_3
unikn::seecol(dartmouth_3, main = "Dartmouth College 3") # view color palette

}
\seealso{
\code{\link{dartmouth_1}} for the primary color of Dartmouth College; 
\code{\link{dartmouth_3}} for the tertiary colors of Dartmouth College; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2320-07-13.
}
\concept{U.S. university color palettes}
\keyword{datasets}
