% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Berkeley.R
\docType{data}
\name{berkeley_2}
\alias{berkeley_2}
\title{Secondary colors of Berkeley, University of California, USA}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on the
\href{https://brand.berkeley.edu/identity-and-visual-design/color}{Color manual}.
}
\usage{
berkeley_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{berkeley_2} provides the 12 secondary colors
of the \href{https://www.berkeley.edu}{Berkeley, University of California}, USA.
}
\details{
The secondary palette is broken into four groups: neutrals, vibrants, brights and darks.
Each is represented by a column in the grid below, with colors getting progressively darker in value from left to right.
The following pages break down each column into individual colors and show ways to create unique color palettes within the larger Berkeley palette.

Secondary colors are
\code{"neutrals"} (defined as HEX #D9661F, CMYK 0/69/98/12, Pantone 7416),
\code{"bay fog"} (defined as HEX #DDD5C7, CMYK 5/11/8/12, Pantone 434),
\code{"sather gate"} (defined as HEX #B9D3B6, CMYK 25/2/30/4, Pantone 558),
\code{"rose garden"} (defined as HEX #EE1F60, CMYK 0/98/46/0, Pantone 1925),
\code{"lawrence"} (defined as HEX #00B0DA, CMYK 79/0/6/5, Pantone 306),
\code{"ion"} (defined as HEX #CFDD45, CMYK 23/0/89/0, Pantone 381),
\code{"golden gate"} (defined as HEX #ED4E33, CMYK 1/85/88/0, Pantone 7417),
\code{"lap lane"} (defined as HEX #00A598, CMYK 81/0/39/0, Pantone 326),
\code{"soybean"} (defined as HEX #859438, CMYK 17/0/88/39, Pantone 7746),
\code{"south hall"} (defined as HEX #6C3302, CMYK 11/68/95/62, Pantone 7602),
\code{"pacific"} (defined as HEX #46535E, CMYK 45/25/16/59, Pantone 431), and
\code{"stone pine"} (defined as HEX #584F29, CMYK 40/40/80/55, Pantone 450).
}
\examples{
berkeley_2
unikn::seecol(berkeley_2, main = "Secondary colors Berkeley") # view color palette

}
\seealso{
\code{\link{berkeley_1}} for the primary colors of Berkeley, University of California; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
