% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMU.R
\docType{data}
\name{CMU_1_core}
\alias{CMU_1_core}
\title{Core colors of Carnegie Mellon University (CMU), USA}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on the
\href{https://www.cmu.edu/brand/brand-guidelines/visual-identity/colors.html}{Color manual}.
}
\usage{
CMU_1_core
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{CMU_1_core} provides five core colors.
of the \href{https://www.cmu.edu}{CMU, Carnegie Mellon University}, USA.
}
\details{
The core colors of Carnegie Mellon University, registered since the late 1920s, are
\code{"carnegie_red"} (defined as CMYK 0/100/79/20, RGB R196/18/48, HEX #C41230),
\code{"iron_gray"} (defined as CMYK 0/0/0/70, RGB R109/110/113, HEX #6D6E71),
\code{"steel_gray"} (defined as CMYK 0/0/0/30, RGB R224/224/224, HEX #E0E0E0),
\code{"black"} (defined as CMYK 0/0/0/100, RGB R0/0/0, HEX #000000), and
\code{"white"}. 

\code{CMU_1_core} uses the HEX color definitions. 

Carnegie red should be the dominant color in your color scheme. The grays, black and white support Carnegie red.
Official university collateral, uniforms, vehicles, signs and other key identity elements should always be produced using the core color palette.
}
\examples{
CMU_1_core
unikn::seecol(CMU_1_core, main = "Core colors CMU") # view color palette

}
\seealso{
\code{\link{CMU_2_tartan}} for secondary colors of CMU, Carnegie Mellon University; 
\code{\link{CMU_3_campus}} for campus colors of CMU, Carnegie Mellon University; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-16.
}
\concept{U.S. university color palettes}
\keyword{datasets}
