% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irvine.R
\docType{data}
\name{uci_3}
\alias{uci_3}
\title{Tertiary colors of the University of California, Irvine, USA}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on 
\href{https://brand.uci.edu/master-branding/color-palette/}{UCI's brand guide}.
}
\usage{
uci_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uci_3} provides the 5 tertiary colors of the 
of the \href{https://www.uci.edu}{University of California Health, Irvine}, USA.
}
\details{
The 5 teritary colors are
\code{"dark_orange"} (defined as HEX #b71234),
\code{"bright_purple"} (defined as HEX #7c109a),
\code{"turquoise"} (defined as HEX #00b0ca),
\code{"lime_green"} (defined as HEX #7ab800) and 
\code{"yellow"} (defined as HEX #fecb00).

\code{uci_3} uses the HEX color definitions.
}
\examples{
uci_3
unikn::seecol(uci_3, main = "U of California, Irvine, 3") # view color palette

}
\seealso{
\code{\link{uci_1}} for primary colors of UC Irvine;
\code{\link{uci_2}} for secondary colors of UC Irvine;
\code{\link{uci_4}} for neutral colors of the UC Irvine;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.
}
\author{
\strong{unicol}, 2023-07-13.
}
\keyword{datasets}
