% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_condensed_slots}
\alias{umx_set_condensed_slots}
\title{umx_set_condensed_slots}
\usage{
umx_set_condensed_slots(state = NA, silent = FALSE)
}
\arguments{
\item{state}{what state (TRUE or FALSE) to set condensed slots (default NA returns current value).}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
\itemize{
\item current value of condensed slots
}
}
\description{
Sets whether newly-created mxMatrices are to be condensed (set to NULL if not being used) or not.
}
\examples{
library(umx)
umx_set_condensed_slots() # print
old = umx_set_condensed_slots(silent = TRUE) # store the existing state
umx_set_condensed_slots(TRUE) # update globally
umx_set_condensed_slots(old) # set back
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Get and set: 
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_dollar_symbol}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_plot_use_hrbrthemes}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_silent}()},
\code{\link{umx_set_table_format}()},
\code{\link{umx}}
}
\concept{Get and set}
