% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxMatrix}
\alias{umxMatrix}
\title{Make a mxMatrix with automatic labels. Also takes name as the first parameter for more readable code.}
\usage{
umxMatrix(
  name = NA,
  type = "Full",
  nrow = NA,
  ncol = NA,
  free = FALSE,
  values = NA,
  labels = TRUE,
  lbound = NA,
  ubound = NA,
  byrow = getOption("mxByrow"),
  baseName = NA,
  dimnames = NA,
  condenseSlots = getOption("mxCondenseMatrixSlots"),
  ...,
  joinKey = as.character(NA),
  joinModel = as.character(NA),
  jiggle = NA
)
}
\arguments{
\item{name}{The name of the matrix (Default = NA). Note the different order compared to mxMatrix!}

\item{type}{The type of the matrix (Default = "Full")}

\item{nrow}{Number of rows in the matrix: Must be set}

\item{ncol}{Number of columns in the matrix: Must be set}

\item{free}{Whether cells are free (Default FALSE)}

\item{values}{The values of the matrix (Default NA)}

\item{labels}{Either whether to label the matrix (default TRUE), OR a vector of labels to apply.}

\item{lbound}{Lower bounds on cells (Defaults to NA)}

\item{ubound}{Upper bounds on cells (Defaults to NA)}

\item{byrow}{Whether to fill the matrix down columns or across rows first (Default = getOption('mxByrow')}

\item{baseName}{Set to override the default (which is to use the matrix name as the prefix).}

\item{dimnames}{NA}

\item{condenseSlots}{Whether to save memory by NULLing out unused matrix elements, like labels, ubound etc. Default = getOption('mxCondenseMatrixSlots')}

\item{...}{Additional parameters (!! not currently supported by umxMatrix)}

\item{joinKey}{See mxMatrix documentation: Defaults to as.character(NA)}

\item{joinModel}{See mxMatrix documentation: Defaults to as.character(NA)}

\item{jiggle}{= NA passed to xmuLabel to jiggle start values (default does nothing)}
}
\value{
\itemize{
\item \code{\link[=mxMatrix]{mxMatrix()}}
}
}
\description{
umxMatrix is a wrapper for mxMatrix which labels cells buy default, and has the name parameter first in order.
}
\examples{
# ==================================================================================
# = 1. Showing how name is first parameter, and how cells are labelled by default. =
# ==================================================================================
umxMatrix("test", "Full", 2, 2)$labels
#      [,1]        [,2]
# [1,] "test_r1c1" "test_r1c2"
# [2,] "test_r2c1" "test_r2c2"

# ===========================================================
# = 2. Over-ride default (matrix name) as prefix for labels =
# ===========================================================
umxMatrix("test", "Full", 2, 2, baseName = "bob")$labels # bob_r1c1


# ==========================================
# = 3. User-provided labels are left as-is =
# ==========================================
umxMatrix("foo", "Lower", nrow=2, ncol=2, labels= c(NA, "beta1", NA))
#      [,1]    [,2]
# [1,] NA      NA  
# [2,] "beta1" NA  

}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=xmu_simplex_corner]{xmu_simplex_corner()}}, \code{\link[=mxMatrix]{mxMatrix()}}, \code{\link[=xmuLabel]{xmuLabel()}}, \code{\link[=umxRAM]{umxRAM()}}
}

Other Core Model Building Functions: 
\code{\link{umxModify}()},
\code{\link{umxPath}()},
\code{\link{umxRAM}()},
\code{\link{umxSuperModel}()},
\code{\link{umx}}
}
\concept{Core Model Building Functions}
