% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxDoCbyPath.R
\name{umxTwinMaker}
\alias{umxTwinMaker}
\title{Make a twin model from the model describing just one person}
\usage{
umxTwinMaker(
  name = "m1",
  paths,
  t1_t2links = list(a = c(1, 0.5), c = c(1, 1), e = c(0, 0)),
  mzData = NULL,
  dzData = NULL,
  sep = "_T"
)
}
\arguments{
\item{name}{The name for the resulting \code{\link[=umxSuperModel]{umxSuperModel()}} (Default "m1")}

\item{paths}{A vector of \code{\link[=umxPath]{umxPath()}}s describing one person}

\item{t1_t2links}{base name (and values) of paths that covary between T1 and T2. Default: c('a'=c(1,.5), 'c'=c(1,1), 'e'=c(0,0))}

\item{mzData}{Data for MZ twins}

\item{dzData}{Data for DZ twins}

\item{sep}{The separator used to create twin 1 and 2 names (Default "_T")}
}
\value{
\itemize{
\item \code{\link[=umxSuperModel]{umxSuperModel()}}
}
}
\description{
\code{xmu_path2twin} takes a collection of paths describing the model for 1 person
and returns a completed twin model. This consists of a \code{\link[=umxSuperModel]{umxSuperModel()}} containing
\code{MZ} and \code{DZ} \code{\link[=umxRAM]{umxRAM()}} models.

Pass into \code{umxTwinMaker}:
\enumerate{
\item A list of \code{paths} making up the twin 1 model
\item In \code{t1_t2links}, a vector describing the component relationships connecting twin 1 to twin 2
(The default here is 1 and .5 for the a, and, for c and e are 1 and 0 in both groups, respectively.
}

\emph{Details}

Some rules. All labels are expanded with a twin suffix: so "var1" -> "var1_T1" etc. so you
provide the person-model using just the base name (and tell umxTwinMaker how to expand it by providing a separator string).

Rule 2: The latent a, c, and e latent variables must be labelled to match the base name given in t1_t2links.
To avoid clashes, variables must not match the numbered variables in \code{t1_t2links}  - by default names like "a1" are reserved for ace.
}
\examples{
\dontrun{
# We'll make some ACE models, but first, let's clean up the twinData 
# set for analysis
# 1. Add a separator to the twin variable names (with sep = "_T")
# 2. Scale the data so it's easier for the optimizer.
data(twinData)
tmp = umx_make_twin_data_nice(data=twinData, sep="", zygosity="zygosity", numbering=1:2)
tmp = umx_scale_wide_twin_data(varsToScale= c("wt", "ht"), sep= "_T", data= tmp)
mzData = subset(tmp, zygosity \%in\%  c("MZFF", "MZMM"))
dzData = subset(tmp, zygosity \%in\%  c("DZFF", "DZMM"))

# ================
# = An ACE model =
# ================
# Define paths: You only need the paths for one person:
paths = c(
umxPath(v1m0 = c("a1", 'c1', "e1")),
umxPath(means = c("wt")),
umxPath(c("a1", 'c1', "e1"), to = "wt", values=.2)
)
m1 = umxTwinMaker("test", paths, mzData = mzData, dzData= dzData)
plot(m1, std= TRUE, means= FALSE)
m2 = umxACE(selDVs="wt", mzData = mzData, dzData=dzData, sep="_T")


# =====================
# = Bivariate example =
# =====================
latents = paste0(rep(c("a", "c", "e"), each = 2), 1:2)
biv = c(
umxPath(v1m0 = latents),
umxPath(mean = c("wt", "ht")),
umxPath(fromEach = c("a1", 'c1', "e1"), to = c("ht", "wt")),
umxPath(c("a2", 'c2', "e2"), to = "wt")
)
tmp= umxTwinMaker(paths= biv, mzData = mzData, dzData= dzData)
plot(tmp, means=FALSE)

# How to use latents other than a, c, and e: define in t1_t2links
paths = c(
umxPath(v1m0 = c("as1", 'c1', "e1")),
umxPath(means = c("wt")),
umxPath(c("as1", 'c1', "e1"), to = "wt", values=.2)
)
m1 = umxTwinMaker("test", paths, mzData = mzData, dzData= dzData, 
	t1_t2links = list('as'=c(1, .5), 'c'=c(1, 1), 'e'=c(0, 0))
)

}

}
\references{
\itemize{
\item \href{https://tbates.github.io}{tutorials}, \href{https://github.com/tbates/umx}{tutorials}
}
}
\seealso{
\itemize{
\item \code{\link[=umxRAM]{umxRAM()}}, \code{\link[=umxSuperModel]{umxSuperModel()}}
}

Other xmu internal not for end user: 
\code{\link{umxModel}()},
\code{\link{umxRenameMatrix}()},
\code{\link{umx_APA_pval}()},
\code{\link{umx_fun_mean_sd}()},
\code{\link{umx_get_bracket_addresses}()},
\code{\link{umx_make}()},
\code{\link{umx_standardize}()},
\code{\link{umx_string_to_algebra}()},
\code{\link{umx}},
\code{\link{xmuHasSquareBrackets}()},
\code{\link{xmuLabel_MATRIX_Model}()},
\code{\link{xmuLabel_Matrix}()},
\code{\link{xmuLabel_RAM_Model}()},
\code{\link{xmuMI}()},
\code{\link{xmuMakeDeviationThresholdsMatrices}()},
\code{\link{xmuMakeOneHeadedPathsFromPathList}()},
\code{\link{xmuMakeTwoHeadedPathsFromPathList}()},
\code{\link{xmuMaxLevels}()},
\code{\link{xmuMinLevels}()},
\code{\link{xmuPropagateLabels}()},
\code{\link{xmuRAM2Ordinal}()},
\code{\link{xmuTwinSuper_Continuous}()},
\code{\link{xmuTwinUpgradeMeansToCovariateModel}()},
\code{\link{xmu_CI_merge}()},
\code{\link{xmu_CI_stash}()},
\code{\link{xmu_DF_to_mxData_TypeCov}()},
\code{\link{xmu_PadAndPruneForDefVars}()},
\code{\link{xmu_cell_is_on}()},
\code{\link{xmu_check_levels_identical}()},
\code{\link{xmu_check_needs_means}()},
\code{\link{xmu_check_variance}()},
\code{\link{xmu_clean_label}()},
\code{\link{xmu_data_missing}()},
\code{\link{xmu_data_swap_a_block}()},
\code{\link{xmu_describe_data_WLS}()},
\code{\link{xmu_dot_make_paths}()},
\code{\link{xmu_dot_make_residuals}()},
\code{\link{xmu_dot_maker}()},
\code{\link{xmu_dot_move_ranks}()},
\code{\link{xmu_dot_rank_str}()},
\code{\link{xmu_extract_column}()},
\code{\link{xmu_get_CI}()},
\code{\link{xmu_lavaan_process_group}()},
\code{\link{xmu_make_TwinSuperModel}()},
\code{\link{xmu_make_bin_cont_pair_data}()},
\code{\link{xmu_make_mxData}()},
\code{\link{xmu_match.arg}()},
\code{\link{xmu_name_from_lavaan_str}()},
\code{\link{xmu_path2twin}()},
\code{\link{xmu_path_regex}()},
\code{\link{xmu_safe_run_summary}()},
\code{\link{xmu_set_sep_from_suffix}()},
\code{\link{xmu_show_fit_or_comparison}()},
\code{\link{xmu_simplex_corner}()},
\code{\link{xmu_standardize_ACEcov}()},
\code{\link{xmu_standardize_ACEv}()},
\code{\link{xmu_standardize_ACE}()},
\code{\link{xmu_standardize_CP}()},
\code{\link{xmu_standardize_IP}()},
\code{\link{xmu_standardize_RAM}()},
\code{\link{xmu_standardize_SexLim}()},
\code{\link{xmu_standardize_Simplex}()},
\code{\link{xmu_start_value_list}()},
\code{\link{xmu_starts}()},
\code{\link{xmu_twin_add_WeightMatrices}()},
\code{\link{xmu_twin_check}()},
\code{\link{xmu_twin_get_var_names}()},
\code{\link{xmu_twin_upgrade_selDvs2SelVars}()}
}
\concept{xmu internal not for end user}
