% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{extractAIC.MxModel}
\alias{extractAIC.MxModel}
\title{Extract AIC from MxModel}
\usage{
\method{extractAIC}{MxModel}(fit, scale, k, ...)
}
\arguments{
\item{fit}{an fitted \code{\link[=mxModel]{mxModel()}} from which to get the AIC}

\item{scale}{not used}

\item{k}{not used}

\item{...}{any other parameters (not used)}
}
\value{
\itemize{
\item AIC value
}
}
\description{
Returns the AIC for an OpenMx model.
Original Author: Brandmaier
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)
extractAIC(m1)
# -2.615998
AIC(m1)
}
\references{
\itemize{
\item \url{https://openmx.ssri.psu.edu/thread/931#comment-4858}
}
}
\seealso{
\itemize{
\item \code{\link[=AIC]{AIC()}}, \code{\link[=umxCompare]{umxCompare()}}, \code{\link[=logLik]{logLik()}}
}

Other Reporting functions: \code{\link{RMSEA.MxModel}()},
  \code{\link{RMSEA.summary.mxmodel}()},
  \code{\link{RMSEA}()}, \code{\link{loadings}()},
  \code{\link{residuals.MxModel}()},
  \code{\link{umxCI_boot}()}, \code{\link{umxCI}()},
  \code{\link{umxCompare}()}, \code{\link{umxConfint}()},
  \code{\link{umxExpCov}()}, \code{\link{umxExpMeans}()},
  \code{\link{umxFitIndices}()},
  \code{\link{umxPlotACEv}()}, \code{\link{umxRotate}()},
  \code{\link{umxSummary.MxModel}()}
}
\concept{Reporting functions}
