% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummaryIP}
\alias{umxSummaryIP}
\alias{umxSummary.MxModelIP}
\title{Present the results of an independent-pathway twin model in table and graphical form}
\usage{
umxSummaryIP(model, digits = 2, file = getOption("umx_auto_plot"),
  returnStd = FALSE, std = TRUE, showRg = FALSE, comparison = NULL,
  CIs = FALSE, show = NULL, ...)
}
\arguments{
\item{model}{A fitted \code{\link[=umxIP]{umxIP()}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{std}{= Whether to show the standardized model (TRUE)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{comparison}{Whether to run mxCompare on a comparison model (NULL)}

\item{CIs}{Confidence intervals (F)}

\item{show}{parameter used in all summary functions. currently ignored here.}

\item{...}{Optional additional parameters}
}
\value{
\itemize{
\item optional \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Summarize a Independent Pathway model, as returned by \code{\link[=umxIP]{umxIP()}}
}
\examples{
require(umx)
data(GFF) # family function and well-being data
mzData <- subset(GFF, zyg_2grp == "MZ")
dzData <- subset(GFF, zyg_2grp == "DZ")
selDVs = c("hap", "sat", "AD") # These will be expanded into "hap_T1" "hap_T2" etc.
m1 = umxIP(selDVs = selDVs, sep = "_T", dzData = dzData, mzData = mzData)
umxSummaryIP(m1)
plot(m1)
\dontrun{
umxSummaryIP(m1, digits = 2, file = "Figure3", showRg = FALSE, CIs = TRUE);
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link{umxIP}()}, \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, SAT, and ACE models.
}

Other Twin Reporting Functions: \code{\link{umxPlotCP}()},
  \code{\link{umxReduceACE}()},
  \code{\link{umxReduceGxE}()}, \code{\link{umxReduce}()},
  \code{\link{umxSummarizeTwinData}()},
  \code{\link{umxSummaryACEcov}()},
  \code{\link{umxSummaryACEv}()},
  \code{\link{umxSummaryACE}()},
  \code{\link{umxSummaryCP}()},
  \code{\link{umxSummaryGxEbiv}()},
  \code{\link{umxSummaryGxE}()},
  \code{\link{umxSummarySexLim}()},
  \code{\link{umxSummarySimplex}()}, \code{\link{umx}}
}
\concept{Twin Reporting Functions}
