% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{ukhp_get}
\alias{ukhp_get}
\title{Get House Price Data}
\usage{
ukhp_get(
  region = "england",
  item = "housePriceIndex",
  regexp = FALSE,
  start_date = NULL,
  end_date = NULL,
  ...
)
}
\arguments{
\item{region}{the region to select. If regexp is set to FALSE then the matching
should be exact, see \code{ukhp_avail_regions} for available regions. If regexp
is set to TRUE then partial matching is possible. Furthermore if it is set to
NULL then selects all available regions.}

\item{item}{the item to select. See \code{ukhp_avail_items} for the available
categories.}

\item{regexp}{use regular expression in sparql to search for regions.}

\item{start_date}{the start date as YYYY-MM-DD.}

\item{end_date}{the end date as YYYY-MM-DD.}

\item{...}{query modifiers passed through \code{rdf_modifiers}.}
}
\value{
Returns a tibble in long format.
}
\description{
The UK House Price Index (UK HPI) captures changes in the value of residential
properties. The UK HPI uses sales data collected on residential housing
transactions, whether for cash or with a mortgage. Data is available at a
national and regional level, as well as counties, local authorities and London boroughs.
}
\details{
Properties have been included:

\itemize{
 \item in England and Wales since January 1995
 \item in Scotland since January 2004
 \item in Northern Ireland since January 2005
}
}
\examples{
\donttest{
# This is case sensitive
ukhp_get("england")

# However you can use regular expression instead of exact match
ukhp_get("england", regexp = TRUE)

# For all available items
ukhp_avail_items()

ukhp_get(c("england", "wales"), item = c("salesVolume", "housePriceIndexDetached"))
}
}
\seealso{
\code{rdf_modifiers}
}
