% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invertItem.R, R/invertItems.R
\name{invertItem}
\alias{invertItem}
\alias{invertItems}
\title{invertItems}
\usage{
invertItem(item, fullRange = NULL, ignorePreviousInversion = FALSE)

invertItems(dat, items = NULL, ...)
}
\arguments{
\item{item}{The vector to invert.}

\item{fullRange}{The full range; will otherwise be derived from the vector.}

\item{ignorePreviousInversion}{Whether to avoid inverting items that were
already inverted.}

\item{dat}{The dataframe containing the variables to invert.}

\item{items}{The names or indices of the variables to invert. If not
supplied (i.e. NULL), all variables in the dataframe will be inverted.}

\item{\dots}{Arguments (parameters) passed on to data.frame when recreating
that after having used lapply.}
}
\value{
The dataframe with the specified items inverted.
}
\description{
Inverts items (as in, in a questionnaire), by calling
\code{\link{invertItem}} on all relevant items.
}
\examples{

invertItems(mtcars, c('cyl'));

}
\seealso{
\code{\link{invertItem}}
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{univariate}
