% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irpplot.R
\name{irpplot}
\alias{irpplot}
\title{Visualising individual response patterns}
\usage{
irpplot(
  data,
  row,
  columns,
  dataName = NULL,
  title = paste("Row", row, "in dataset", dataName)
)
}
\arguments{
\item{data}{A dataframe with the dataset containing
the responses.}

\item{row}{A vector with indices of the rows for which
you want the individual response patterns. These can be
either the relevant row numbers, or if character row
names are set, the names ot the rleevant rows.}

\item{columns}{A vector with the names of the variables
you want the individual response patterns for.}

\item{dataName, title}{Optionally, you can override the
dataset name that is used in the title; or, the title
(the dataset name is only used in the title).}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualising individual response patterns
}
\examples{
### Get a dataset
dat <- ufs::bfi;

### Show the individual responses for
### the tenth participant
irpplot(dat, 10, 1:20);

### Set some missing values
dat[10, c(1, 5, 15)] <- NA;

### Show the individual responses again
irpplot(dat, 10, 1:20);
}
