% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spearmanBrown.R
\name{spearmanBrown}
\alias{spearmanBrown}
\alias{spearmanBrown_reversed}
\alias{spearmanBrown_requiredLength}
\title{Spearman-Brown formula}
\usage{
spearmanBrown(nrOfItems, itemReliability)

spearmanBrown_reversed(nrOfItems, scaleReliability)

spearmanBrown_requiredLength(scaleReliability, itemReliability)
}
\arguments{
\item{nrOfItems}{Number of items (or 'subtests') in the scale (or 'test').}

\item{itemReliability}{The reliability of one item (or 'subtest').}

\item{scaleReliability}{The reliability of the scale (or, desired reliability of the scale).}
}
\value{
For \code{spearmanBrown}, the predicted scale reliability; for \code{spearmanBrown_requiredLength},
the number of items required to achieve the desired scale reliability; and for \code{spearmanBrown_reversed},
the reliability of one item.
}
\description{
Spearman-Brown formula
}
\examples{
spearmanBrown(10, .4);
spearmanBrown_reversed(10, .87);
spearmanBrown_requiredLength(.87, .4);
}
