% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udpipe_train.R
\name{udpipe_read_conllu}
\alias{udpipe_read_conllu}
\title{Read in a CONLL-U file as a data.frame}
\usage{
udpipe_read_conllu(file)
}
\arguments{
\item{file}{a connection object or a character string with the location of the file}
}
\value{
a data.frame with columns doc_id, paragraph_id, sentence_id, sentence, 
token_id, token, lemma, upos, xpos, feats, head_token_id, deprel, dep_rel, misc
}
\description{
Read in a CONLL-U file as a data.frame
}
\examples{
file_conllu <- system.file(package = "udpipe", "dummydata", "traindata.conllu")
x <- udpipe_read_conllu(file_conllu)
head(x)
}
