% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_new}
\alias{system_new}
\title{Create New \code{system.txt} File}
\usage{
system_new(file_name = "system.txt", system_file = "template",
  overwrite = FALSE, output_directory = getwd())
}
\arguments{
\item{file_name}{name of the new file to create}

\item{system_file}{name of the system file to copy}

\item{overwrite}{if \code{TRUE} the new system file will overwrite any existing files present}

\item{output_directory}{\code{getwd()} directory where system file will be placed}
}
\value{
\code{TRUE} if the new file was created and \code{FALSE} otherwise
}
\description{
Copy a blank template (\code{system_file="template"}) file to the working directory or an example by specifying the following:

\itemize{
  \item \code{"template"} - Empty system file template
  \item \code{"two_cmt_macro"} - Two compartment model parameterized in terms of clearances (macro constants)
  \item \code{"one_cmt_macro"} - One compartment model parameterized in terms of clearances (macro constants)
  \item \code{"two_cmt_micro"} - Two compartment model parameterized in terms of rates (micro constants)
  \item \code{"one_cmt_micro"} - One compartment model parameterized in terms of rates (micro constants)
  \item \code{"adapt"} - Parent/metabolite model taken from the adapt manual used in estimation examples
  \item \code{"mab_pk"} - General compartmental model of mAb PK from Davda 2014 http://doi.org/10.4161/mabs.29095
  \item \code{"pbpk"} - PBPK model of mAb disposition in mice from Shah 2012 
  \item \code{"tmdd"} - Model of antibody with target-mediated drug disposition
  \item \code{"pwc"} - Example showing how to make if/then or piece-wise continuous variables  
  \item \code{"empty"} - Minimal system file used to perform other analyses (e.g, NCA)
}
}
\examples{
\donttest{
# To create an example system file named example_system.txt:
system_new(system_file      = "mab_pk", 
           file_name        = "system_example.txt", 
           overwrite        = TRUE,  
           output_directory = tempdir())
}
}
