% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAINest.R
\name{fitGMAR}
\alias{fitGMAR}
\title{Estimate Gaussian or Student's t Mixture Autoregressive model}
\usage{
fitGMAR(data, p, M, StMAR = FALSE, GStMAR = FALSE, restricted = FALSE,
  constraints = FALSE, R, conditional = TRUE, nCalls, multicore = TRUE,
  ncores, initpop = FALSE, ngen, popsize, smartMu, ar0scale, sigmascale,
  printRes = TRUE, runTests = FALSE)
}
\arguments{
\item{data}{a numeric vector or column matrix containing the data. \code{NA} values are not supported.}

\item{p}{a positive integer specifying the order of AR coefficients.}

\item{M}{a positive integer specifying the number of mixture components. Except for G-StMAR model a size (2x1) vector specifying the number of GMAR-components M1 in
the first element and StMAR-components M2 in the second - then the total number of components is M=M1+M2.}

\item{StMAR}{an (optional) logical argument stating whether StMAR model should be considered instead of GMAR model. Default is \code{FALSE}.}

\item{GStMAR}{an (optional) logical argument stating whether G-StMAR model should be considered instead of GMAR model. In G-StMAR model the first M1 components
are GMAR-type and the rest M2 components are StMAR-type. Default is \code{FALSE}.}

\item{restricted}{an (optional) logical argument stating whether the AR coefficients \eqn{\phi_{m,1},...,\phi_{m,p}} are restricted
to be the same for all regimes. Default is \code{FALSE}.}

\item{constraints}{an (optional) logical argument stating whether general linear constraints should be applied to the model. Default is \code{FALSE}.}

\item{R}{Specifies the linear constraints.
\describe{
\item{For \strong{non-restricted} models:}{a list of size \eqn{(pxq_{m})} constraint matrices \strong{\eqn{R_{m}}} of full column rank
  satisfying \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{R_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
  \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p})} and \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
\item{For \strong{restricted} models:}{a size \eqn{(pxq)} constraint matrix \strong{\eqn{R}} of full column rank satisfying
  \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{R\psi}}, where \strong{\eqn{\phi}}\eqn{=(\phi_{1},...,\phi_{p})} and
  \strong{\eqn{\psi}}\eqn{=\psi_{1},...,\psi_{q}}.}
}
Symbol \eqn{\phi} denotes an AR coefficient. Note that regardless of any constraints, the nominal order of AR coefficients is alway \code{p} for all regimes.
This argument is ignored if \code{constraints==FALSE}.}

\item{conditional}{an (optional) logical argument specifying wether the conditional or exact log-likehood function should be used. Default is \code{TRUE}.}

\item{nCalls}{an (optional) positive integer specifying how many rounds of estimation should be done.
The estimation results may vary from round to round because of multimodality of the log-likelihood function
and randomness associated with the genetic algorithm. Default is \code{round(10 + 9*log(M))}.}

\item{multicore}{an (optional) logical argument defining whether parallel computing should be used in the estimation process.
Highly recommended and default is \code{TRUE}.}

\item{ncores}{an (optional) positive integer specifying the number of cores to be used in the estimation process.
Default is that the number of available cores is detected with \code{parallel::detectCores()} and all them are used. Ignored if \code{multicore==FALSE}.}

\item{initpop}{an (optional) list of parameter vectors from which the initial population of the genetic algorithm will be generated from.
 The parameter vectors should be of form...
\describe{
  \item{For \strong{non-restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(M(p+3)-1x1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}}), where \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,
        \sigma_{m}^2)} and \strong{\eqn{\phi_{m}}}=\eqn{(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(M(p+4)-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M}}).}
      \item{For \strong{G-StMAR} model:}{Size \eqn{(M(p+3)+M2-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
        \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{M1+1},...,\nu_{M}}).}
      \item{With \strong{linear constraints}:}{Replace the vectors \strong{\eqn{\phi_{m}}} with vectors \strong{\eqn{\psi_{m}}} and provide a  list of constraint
        matrices \strong{R} that satisfy \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{R_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
        \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
    }
  }
  \item{For \strong{restricted} models:}{
    \describe{
      \item{For \strong{GMAR} model:}{Size \eqn{(3M+p-1x1)} vector \strong{\eqn{\theta}}\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1})}, where \strong{\eqn{\phi}}=\eqn{(\phi_{1},...,\phi_{M})}.}
      \item{For \strong{StMAR} model:}{Size \eqn{(4M+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M})}.}
      \item{For \strong{G-StMAR} model:}{Size \eqn{(3M+M2+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
        \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{M1+1},...,\nu_{M})}.}
      \item{With \strong{linear constraints}:}{Replace the vector \strong{\eqn{\phi}} with vector \strong{\eqn{\psi}} and provide a constraint matrix
        \strong{\eqn{R}} that satisfies \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{R\psi}}, where
        \strong{\eqn{\psi}}\eqn{=(\psi_{1},...,\psi_{q})}.}
    }
  }
}
Symbol \eqn{\phi} denotes an AR coefficient, \eqn{\sigma^2} a variance, \eqn{\alpha} a mixing weight and \eqn{v} a degrees of
freedom parameter.
Note that in the case \strong{M=1} the parameter \eqn{\alpha} is dropped, and in the case of \strong{StMAR} or \strong{G-StMAR} model
the degrees of freedom parameters \eqn{\nu_{m}} have to be larger than \eqn{2}.
If not specified (or \code{FALSE} as is default), the initial population will be drawn randomly.}

\item{ngen}{an (optional) positive integer specifying the number of generations to be ran through in the genetic algorithm. Default is \code{min(400, max(round(0.1*length(data)), 200))}.}

\item{popsize}{an (optional) positive even integer specifying the population size in the genetic algorithm. Default is \code{10*d} where \code{d} is the number of parameters.}

\item{smartMu}{an (optional) positive integer specifying the generation after which the random mutations in the genetic algorithm are "smart".
This means that mutating individuals will mostly mutate fairly close (or partially close) to the best fitting individual so far. Default is \code{min(100, round(0.5*ngen))}.}

\item{ar0scale}{an (optional) real valued vector of length two specifying the mean (the first element) and standard deviation (the second element) of the normal distribution
from which the \eqn{\phi_{m,0}} parameters are generated in random mutations in the genetic algorithm. Default is \code{c(1.5*avg*(1-c1/c0), max(c0, 4))}, where
avg is sample mean, \code{c1} is the first sample autocovariance and \code{c0} is sample variance.}

\item{sigmascale}{an (optional) positive real number specifying the standard deviation of the (zero mean, positive only) normal distribution
from which the component variance parameters are generated in the random mutations in the genetic algorithm. Default is \code{1+sd(data)}.}

\item{printRes}{an (optional) logical argument defining whether results should be printed or not. Default is \code{TRUE}.}

\item{runTests}{an (optional) logical argument defining whether quantile residual tests for the estimated model should be performed or not. Default is \code{FALSE}.}
}
\value{
Returns a list with...
\describe{
  \item{\code{$estimates}}{The estimated parameter vector...
 \describe{
   \item{For \strong{non-restricted} models:}{
     \describe{
       \item{For \strong{GMAR} model:}{Size \eqn{(M(p+3)-1x1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
         \eqn{\alpha_{1},...,\alpha_{M-1}}), where \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,
         \sigma_{m}^2)} and \strong{\eqn{\phi_{m}}}=\eqn{(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}.}
       \item{For \strong{StMAR} model:}{Size \eqn{(M(p+4)-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
         \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M}}).}
       \item{For \strong{G-StMAR} model:}{Size \eqn{(M(p+3)+M2-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
         \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{M1+1},...,\nu_{M}}).}
       \item{With \strong{linear constraints}:}{Parameter vector as descripted above, but vectors \strong{\eqn{\phi_{m}}} replaced with vectors \strong{\eqn{\psi_{m}}}
         that satisfy \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{R_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
         \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
     }
   }
   \item{For \strong{restricted} models:}{
     \describe{
       \item{For \strong{GMAR} model:}{Size \eqn{(3M+p-1x1)} vector \strong{\eqn{\theta}}\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
         \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1})}, where \strong{\eqn{\phi}}=\eqn{(\phi_{1},...,\phi_{M})}.}
       \item{For \strong{StMAR} model:}{Size \eqn{(4M+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
         \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M})}.}
       \item{For \strong{G-StMAR} model:}{Size \eqn{(3M+M2+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
         \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{M1+1},...,\nu_{M})}.}
       \item{With \strong{linear constraints}:}{Parameter vector as descripted above, but vector \strong{\eqn{\phi}} replaced with vector \strong{\eqn{\psi}}
         that satisfies \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{R\psi}}, where
         \strong{\eqn{\psi}}\eqn{=(\psi_{1},...,\psi_{q})}.}
     }
   }
 }
 Symbol \eqn{\phi} denotes an AR coefficient, \eqn{\sigma^2} a variance, \eqn{\alpha} a mixing weight and \eqn{\nu} a degrees of
 freedom parameter. In the \strong{G-StMAR} model the first M1 components are GMAR-type and the rest M2 components are StMAR-type.}
  \item{\code{$stdErrors}}{Approximate standard errors of the estimates. \code{NA} values may sometimes occur because the observed information matrix is numerically estimated.}
  \item{\code{$loglikelihood}}{Log-likelihood value of the estimated model.}
  \item{\code{$IC}}{A data frame containing information criteria scores of the estimated model: \code{$AIC}, \code{$BIC}, \code{$HQIC}.}
  \item{\code{$quantileResiduals}}{A numeric vector containing quantile residuals of the estimated model.}
  \item{\code{$mixingWeights}}{A numeric matrix containing mixing weights of the estimated model (i:th column for i:th regime).}
  \item{\code{$allEstimates}}{A list of estimated parameter vectors from all of the estimation rounds.}
  \item{\code{$allLoglikelihoods}}{A numeric vector containing the log-likelihood values from all of the estimation rounds. Corresponds to \code{$allEstimates}.}
  \item{\code{$converged}}{A logical vector containing information whether the quasi-Newton algorithm converged successfully or not. Corresponds to \code{$allEstimates}.}
  \item{\code{$normality}}{A data frame containing results from the normality test. Returned only if \code{runTests==TRUE}.}
  \item{\code{$autocorrelation}}{A data frame containing results from the autocorrelation tests. Returned only if \code{runTests==TRUE}.}
  \item{\code{$cond.heteroscedasticity}}{A data frame containing results from the conditional heteroscedasticity tests. Returned only if \code{runTests==TRUE}.}
  \item{\code{$unconstrainedEstimates}}{A numeric parameter vector denoting the estimates without any constraints (if given any). That is instead of
    vectors \strong{\eqn{\psi_{m}}} the estimates are parametrized with vectors \strong{\eqn{\phi_{m}}} calculated from
    \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{R_{m}\psi_{m}}}, or in the case of restricted models
    \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{R\psi}}. Returned only if \code{constraints==TRUE}.}
}
}
\description{
\code{fitGMAR} estimates GMAR, StMAR or G-StMAR model in two phases. It uses genetic algorithm to find parameter values close to the maximum point
 of the log-likelihood function and then uses them as starting values for quasi-Newton method to find the maximum point.
}
\details{
The user should consider adjusting \code{ar0scale} and/or \code{sigmascale} accordingly to the best knowledge about the process.

  Note that \code{fitGMAR} can't verify whether the found estimates denote the global or just a local maximum point.
  For more reliable results one should increase the number of estimation rounds (\code{nCalls}) to be performed.
}
\section{Printed results}{

  The results printed out regarding the genetic algorithm and quasi-Newton estimations are the log-likelihood values
  the algorithms ended up with. The lowest value, mean value and largest value are printed to give perspective.

  If quantile residual tests are ran, the results from the tests are printed so that the letter "N" means normality test, "A" autocorrelation test
  and "H" conditional heteroscedasticity test. The numbers right next to "A" and "H" indicate the number of lags used
  in each test. The statistics following them are the corresponding test statistics and p-values.
  \code{NA} values mean that it was not (numerically) possible for the code to calculate all the necessary estimates for the tests.
}

\section{Suggested packages}{

  Install the suggested package "pbapply" if you wish to see a progress bar during parallel computing.

  For faster evaluation of the quantile residuals of StMAR and G-StMAR models install the suggested package "gsl".
  Note that for large StMAR and G-StMAR models with large data the evaluations for the quantile residual tests may take
  significantly long time without the package "gsl".
}

\section{The optimization algorithms}{

  The genetic algorithm is mostly based on the description by \emph{Dorsey R. E. ja Mayer W. J. (1995)}. It uses individually
  adaptive crossover and mutation rates described by \emph{Patnaik L.M. and Srinivas M. (1994)}, with slight modifications.

  The quasi-Newton method is implemented with function \code{optim} from the package \code{stats}.
}

\examples{
\donttest{
# GMAR model
fit12 <- fitGMAR(VIX, 1, 2, ar0scale=c(3, 2), runTests=TRUE)

# Restricted GMAR model
fit12r <- fitGMAR(VIX, 1, 2, restricted=TRUE, nCalls=10,
                  runTests=TRUE)

# StMAR model
fit12t <- fitGMAR(VIX, 1, 2, StMAR=TRUE, ar0scale=c(3, 2))

# Non-mixture version of StMAR model: without multicore
fit11t <- fitGMAR(VIX, 1, 1, StMAR=TRUE, multicore=FALSE, nCalls=4, runTests=TRUE)

# GStMAR model
fit12gs <- fitGMAR(VIX, 1, c(1, 1), GStMAR=TRUE, conditional=FALSE)

# Restricted G-StMAR model
fit12gsr <- fitGMAR(VIX, 1, c(1, 1), GStMAR=TRUE, restricted=TRUE)

# Fit GMAR model that is a mixture of AR(1) and such AR(3) model that the
# second AR coeffiecient is constrained to zero.
R <- list(matrix(c(1, 0, 0, 0, 0, 1), ncol=2), as.matrix(c(1, 0, 0)))
fit32c <- fitGMAR(VIX, 3, 2, constraints=TRUE, R=R, ar0scale=c(3, 2))

# Fit such constrained StMAR(3, 1) model that the second order AR coefficient
# is constrained to zero.
R0 <- matrix(c(1, 0, 0, 0, 0, 1), ncol=2)
fit31tc <- fitGMAR(VIX, 3, 1, StMAR=TRUE, constraints=TRUE, R=list(R0))

# Fit such StMAR(3,2) model that the AR coefficients are restricted to be
# the same for both regimes and that the second AR coefficients are
# constrained to zero.
fit32trc <- fitGMAR(VIX, 3, 2, StMAR=TRUE, restricted=TRUE, constraints=TRUE,
                    R=matrix(c(1, 0, 0, 0, 0, 1), ncol=2))
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. (2015) Gaussian Mixture Autoregressive model for univariate time series.
         \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
         \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Dorsey R. E. ja Mayer W. J. (1995) Genetic algorithms for estimation problems with multiple optima, nondifferentiability, and other irregular features.
         \emph{Journal of Business & Economic Statistics}, \strong{13}, 53-66.
   \item Patnaik L.M. and Srinivas M. (1994) Adaptive Probabilities of Crossover and Mutation in Genetic Algorithms.
         \emph{Transactions on Systems, Man and Cybernetics} \strong{24}, 656-667.
   \item Lutkepohl H. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}, 2005.
   \item Galbraith, R., Galbraith, J., (1974). On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item References regarding the StMAR and G-StMAR models will be updated after they are published.
 }
}
