% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bound.R
\name{scale_to_original}
\alias{scale_to_original}
\title{Transform values from the unit interval back to their original scale}
\usage{
scale_to_original(scaled_vals, max_orig, min_orig)
}
\arguments{
\item{scaled_vals}{A \code{numeric} vector corresponding to re-scaled values
in the unit interval, to be re-scaled to the original interval.}

\item{max_orig}{A \code{numeric} scalar value giving the maximum of the
values on the original scale.}

\item{min_orig}{A \code{numeric} scalar value giving the minimum of the
values on the original scale.}
}
\value{
A \code{numeric} vector of the same length as \code{scaled_vals},
 where the values are re-scaled to lie in their original/natural interval.
}
\description{
Transform values from the unit interval back to their original scale
}
\details{
A back-transformation that returns values computed in the unit
 interval to their original scale. This is used in re-scaling updated TML
 estimates back to their natural scale. Undoes \code{\link{scale_to_unit}}.
}
