% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{tsvGetData}
\alias{tsvGetData}
\title{Read matching lines from a tsv file, using a pre-computed index file.}
\usage{
tsvGetData(
  filename,
  indexfile,
  rowpatterns,
  colpatterns,
  dtype = "",
  findany = TRUE
)
}
\arguments{
\item{filename}{The name (and path) of the file containing the data to index.}

\item{indexfile}{The name (and path) of the file to which the index will be written.}

\item{rowpatterns}{A vector of strings containing the string to match against the index entries.  Only
lines with keys that exactly match at least one pattern string are returned.  If rowpatterns is NULL,
data from all rows is returned.}

\item{colpatterns}{A vector of strings to match against the column headers in the first row}

\item{dtype}{A prototype element that specifies by example the type of matrix to return.  The
value of the parameter is ignored.  Accepted types are string (default), numeric (float), and integer.}

\item{findany}{If false, all patterns must be matched. If true (default) at least one pattern must match.}
}
\value{
A matrix containing one row for each matched line and one column for each matched column.
}
\description{
This function reads lines that match the given patterns from a TSV file with the assistance of
a pre-computed index file to the start of each row.
}
\details{
The index file must have been created by tsvGenIndex and the data file must not have changed
since the index file was created.
}
\examples{
datafile = tempfile("data");
df <- data.frame(C1 = c("Foo", "Boing", "The"), C2 = c("Bar", "Boing", "End"));
rownames(df) <- c("R1", "R2", "R3");
write.table(df, file=datafile, sep="\t", quote=FALSE, row.names=TRUE, col.names=TRUE);
indexfile = tempfile("index");
tsvGenIndex (datafile, indexfile);
tsvGetData (datafile, indexfile, c("R1", "R3"), c('C2'))

}
\seealso{
tsvGenIndex, tsvGetLines
}
