% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_stretch.R
\name{ts_aug_stretch}
\alias{ts_aug_stretch}
\title{Augmentation by stretch}
\usage{
ts_aug_stretch(scale_factor = 1.2)
}
\arguments{
\item{scale_factor}{for stretch}
}
\value{
a \code{ts_aug_stretch} object.
}
\description{
Time series data augmentation is a technique used to increase the size and diversity of a time series dataset by creating new instances of the original data through transformations or modifications. The goal is to improve the performance of machine learning models trained on time series data by reducing overfitting and improving generalization.
stretch does data augmentation by increasing the volatility of the time series.
}
\examples{
library(daltoolbox)
data(sin_data)

#convert to sliding windows
xw <- ts_data(sin_data$y, 10)

#data augmentation using flip
augment <- ts_aug_stretch()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
