% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{stretch}
\alias{stretch}
\alias{stretch.default}
\alias{stretch.data.frame}
\alias{stretcher}
\title{Stretching window calculation}
\usage{
stretch(x, .f, ..., size = 1, init = 1)

\method{stretch}{default}(x, .f, ..., size = 1, init = 1)

\method{stretch}{data.frame}(x, .f, ..., size = 1, init = 1,
  deframe = TRUE)

stretcher(x, size = 1, init = 1)
}
\arguments{
\item{x}{A vector of numerics, or data frame.}

\item{.f}{A function or one-sided formula using purrr-like syntax. If a
formula, it is converted to a function.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{size, init}{An integer for moving and initial window size.}

\item{deframe}{TRUE a list is returned. FALSE returns a data frame.}
}
\description{
\code{stretch()} is an S3 method to carry out expanding window calculation;
\code{stretcher()} splits the input \code{x} to a list according to the window size.
}
\examples{
x <- 1:10
stretch(x, mean, init = 3)
stretch(x, ~ mean(.), init = 3)
stretcher(x, init = 3)

# stretching a 2-day window for a data frame ----
sx <- pedestrian \%>\% 
  filter(Sensor == "Southern Cross Station", Date <= as.Date("2015-01-10"))
sx \%>\%
  stretch(~ quantile(.$Count), init = 48, deframe = FALSE)
}
\seealso{
\link{slide} for sliding window with overlapping observations;
\link{tile} for tiling window without overlapping observations.
}
