% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featurematrix.R, R/tsfeatures.R
\docType{package}
\name{tsfeatures}
\alias{tsfeatures}
\title{Time series feature matrix}
\usage{
tsfeatures(
  tslist,
  features = c("frequency", "stl_features", "entropy", "acf_features"),
  scale = TRUE,
  trim = FALSE,
  trim_amount = 0.1,
  parallel = FALSE,
  multiprocess = future::multisession,
  na.action = na.pass,
  ...
)
}
\arguments{
\item{tslist}{a list of univariate time series, each of class \code{ts} or a numeric vector.
Alternatively, an object of class \code{mts} may be used.}

\item{features}{a vector of function names which return numeric vectors of features.
All features returned by these functions must be named if they return more than one feature.
Existing functions from installed packages may be used, but the package must be loaded first.
Functions must return a result for all time series, even if it is just NA.}

\item{scale}{if \code{TRUE}, time series are scaled to mean 0 and sd 1 before features
are computed.}

\item{trim}{if \code{TRUE}, time series are trimmed by \code{trim_amount} before features
are computed. Values larger than \code{trim_amount} in absolute value are set to \code{NA}.}

\item{trim_amount}{Default level of trimming if \code{trim==TRUE}.}

\item{parallel}{If TRUE, multiple cores (or multiple sessions) will be used. This only speeds things up
when there are a large number of time series.}

\item{multiprocess}{The function from the \code{future} package to use for parallel processing. Either
\code{\link[future]{multisession}} or \code{\link[future]{multicore}}. The latter is preferred
for Linux and MacOS.}

\item{na.action}{A function to handle missing values. Use \code{na.interp} to estimate missing values.}

\item{...}{Other arguments get passed to the feature functions.}
}
\value{
A feature matrix (in the form of a tibble) with each row corresponding to
one time series from tslist, and each column being a feature.
}
\description{
\code{tsfeatures} computes a matrix of time series features from a list of time series

The tsfeature package provides methods to extract various features from time series data
}
\examples{
mylist <- list(sunspot.year, WWWusage, AirPassengers, USAccDeaths)
tsfeatures(mylist)
}
\author{
Rob J Hyndman
}
