# tscopula

## Time Series Copula Models

This package contains functions for the analysis of time series using copula models. A full description of a strictly stationary time series can be obtained by choosing a univariate marginal distribution and a time series copula process, i.e. a serially dependent process of uniform random variables. Examples of the latter are the copula processes of Gaussian ARMA models and D-vine copula processes. Methods are provided for simulation, estimation and forecasting of time series copula models.

## References

McNeil, A.J. (2021). Modelling volatile time series with v-transforms and copulas. Risks, 9(14). https://www.mdpi.com/2227-9091/9/1/14

Bladt, M., & McNeil, A.J. (2021). Time series copula models using d-vines and v-transforms. Econometrics and Statistics.
https://www.sciencedirect.com/science/article/pii/S2452306221000800

Bladt, M., & McNeil, A.J. (2021). Time series models with infinite-order partial copula dependence.
https://arxiv.org/abs/2107.00960
