\encoding{utf-8}
\name{trustOptim-package}
\alias{trustOptim-package}
\alias{trustOptim}
\docType{package}
\title{
Nonlinear optimizers using trust regions, with methods optimized for sparse Hessians.
}
\description{
Trust region algorithm for nonlinear minimization. The
package includes methods that are designed to be efficient (in terms
of both speed and memory usage) when the Hessian is sparse, and when
the Hessian structure is known in advance.

License details are available in the LICENSE file in the source code.
There are restrictions on redistribution and use, and the user is
encouraged to become familiar with them.
}
\details{
\tabular{ll}{
Package: \tab trustOptim\cr
Type: \tab Package\cr
Version: \tab 0.7-0\cr
Date: \tab 2012-08-22\cr
License: \tab See the LICENSE file included in the source code.\cr
LazyLoad: \tab yes\cr
}

}
\author{
Michael Braun <braunm@mit.edu>
}

\references{
Coleman, Thomas F, Burton S Garbow, and Jorge J More. 1985. Software
for Estimating Sparse Hessian Matrices. ACM Transaction on
Mathematical Software 11 (4) (December): 363–377. 

Coleman, Thomas F, Burton S Garbow, and Jorge J More. 1985. Algorithm
636:  FORTRAN Subroutines for Estimating Sparse Hessian Matrices. ACM
Transactions on Mathematical Software 11 (4): 378.

Nocedal, Jorge, and Stephen J Wright. 2006. Numerical Optimization. Second edition. Springer.

Steihaug, Trond. 1983. The Conjugate Gradient Method and Trust
Regions in Large Scale Optimization. SIAM Journal on Numerical
Analysis 20 (3): 626–637.
}

\keyword{ package }

