% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_troopdata.R
\name{get_troopdata}
\alias{get_troopdata}
\title{Function to retrieve customized U.S. troop deployment data}
\usage{
get_troopdata(
  host = NULL,
  branch = FALSE,
  startyear = 1950,
  endyear = 2024,
  quarters = FALSE,
  guard_reserve = FALSE,
  civilians = FALSE,
  reports = FALSE
)
}
\arguments{
\item{host}{The Correlates of War (COW) numeric country code, ISO3C code, or country name, for the host country or countries in the series. If region == TRUE the user can specify a COW region name and the function will try to match it to the region column in the data. The default is NA.}

\item{branch}{Logical. Should the function return a single vector containing total troop values or multiple vectors containing total values and values for individual branches? Default is FALSE.}

\item{startyear}{The first year for the series. The default is set to 1950.}

\item{endyear}{The last year for the series. The default is the maximum year in the currently published data.}

\item{quarters}{Logical. Should the function return quarterly data? Default is FALSE.}

\item{guard_reserve}{Logical. Should the function return values for the National Guard and Reserve? Default is FALSE.}

\item{civilians}{Logical. Should the function return values for civilian DoD personnel? Default is FALSE.}

\item{reports}{Logical. Should the function return reports for the specified countries and years? Default is FALSE.}
}
\value{
\code{get_troopdata()} returns a data frame containing country-year observations for U.S. troop deployments.
}
\description{
\code{get_troopdata()} generates a customized data frame containing country-year observations of U.S. military deployments overseas.
}
\examples{

\dontrun{
library(tidyverse)
library(troopdata)

example <- get_troopdata(host = "United States",
                        branch = TRUE,
                        startyear = 1980,
                        endyear = 2015)

head(example)

}

}
\references{
Tim Kane. Global U.S. troop deployment, 1950-2003. Technical Report. Heritage Foundation, Washington, D.C.

Michael A. Allen, Michael E. Flynn, and Carla Martinez Machain. 2022. "Global U.S. military deployment data: 1950-2020." Conflict Management and Peace Science. 39(3): 351-370.
}
\author{
Michael E. Flynn
}
