% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{trip-class}
\alias{trip-class}
\alias{lines,trip-method}
\alias{plot,trip,missing-method}
\alias{show,trip-method}
\alias{show,summary.TORdata-method}
\alias{summary,trip-method}
\alias{subset,trip-method}
\title{A class for sets of animal trips (track data).}
\description{
An extension of \code{\link[sp]{SpatialPointsDataFrame-class}} by including
\code{"TimeOrderedRecords"}.  The records within the data frame are
explicitly ordered by DateTime data within IDs.
}
\section{Objects from the Class}{


Objects can be created by calls of the form
\code{trip(obj="SpatialPointsDataFrame", TORnames="TimeOrderedRecords")}.
The object contains all the slots present within a
\code{\link[sp]{SpatialPointsDataFrame-class}}, particularly \code{data} which
contains columns of at least those specified by \code{TOR.columns}.
}

\examples{


showClass("trip")

d <- data.frame(x=1:10, y=rnorm(10), tms=Sys.time() + 1:10, id=gl(2, 5))
tr <- trip(d)

summary(tr)
plot(tr)
lines(tr)

dim(tr)
names(tr)
subset(tr, id == "2")
as.data.frame(tr)

tr[1:3, ]
tr[, 1]
tr[[1]]



}
\seealso{
\code{\link{trip}} for examples of directly using the class.

\code{\link{trip-accessors}} describes methods for accessing information on
\code{trip} objects.
}
\keyword{classes}
