% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp_equal.R
\name{interp_equal}
\alias{interp_equal}
\title{Track intermediate points}
\usage{
interp_equal(x, distance = NULL, duration = NULL)
}
\arguments{
\item{x}{trip object}

\item{distance}{optional minimum distance (metres) between interpolated points}

\item{duration}{optional minimum duration (seconds) between interpolated points}
}
\value{
S4 trip object with interpolated new locations based on distance or duration parameters
}
\description{
Calculate great circle intermediate points on longitude, latitude input vectors. A spherical model is used, from the geosphere package.
}
\details{
For the result to be sensible, the input must either be in longitude/latitude, or be in a projection and have a valid CRS. Great
circle movement is assumed, there's no way to use this to interpolate equal-distance in the native projection.

If no input \code{distance} or \code{duration} is provided a default is used of 15 points between each input point.

if both \code{distance} AND \code{duration} is provided, \code{distance} is ignored.

Note, the original implementation of this function was called 'interpequal()', and was used for time spent
calculations. The functionality is now provided by the traipse package.
}
