% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_predictive_augbin_2t_1a.R
\name{prior_predictive_augbin_2t_1a}
\alias{prior_predictive_augbin_2t_1a}
\title{Sample data from the Augmented Binary model prior predictive distribution.}
\usage{
prior_predictive_augbin_2t_1a(
  num_samps,
  alpha_mean,
  alpha_sd,
  beta_mean,
  beta_sd,
  gamma_mean,
  gamma_sd,
  sigma_mean,
  sigma_sd,
  omega_lkj_eta,
  alpha_d1_mean,
  alpha_d1_sd,
  gamma_d1_mean,
  gamma_d1_sd,
  alpha_d2_mean,
  alpha_d2_sd,
  gamma_d2_mean,
  gamma_d2_sd
)
}
\arguments{
\item{num_samps}{Number of samples.}

\item{alpha_mean}{Prior mean of alpha parameter.}

\item{alpha_sd}{Prior sd of alpha parameter.}

\item{beta_mean}{Prior mean of beta parameter.}

\item{beta_sd}{Prior sd of beta parameter.}

\item{gamma_mean}{Prior mean of gamma parameter.}

\item{gamma_sd}{Prior sd of gamma parameter.}

\item{sigma_mean}{Prior mean of sigma parameter.}

\item{sigma_sd}{Prior sd of sigma parameter.}

\item{omega_lkj_eta}{Prior eta parameter for LKJ prior on covariance matrix
of log tumour sizes.}

\item{alpha_d1_mean}{Prior mean of alpha_D1 parameter.}

\item{alpha_d1_sd}{Prior sd of alpha_D1 parameter.}

\item{gamma_d1_mean}{Prior mean of gamma_D1 parameter.}

\item{gamma_d1_sd}{Prior sd of gamma_D1 parameter.}

\item{alpha_d2_mean}{Prior mean of alpha_D2 parameter.}

\item{alpha_d2_sd}{Prior sd of alpha_D2 parameter.}

\item{gamma_d2_mean}{Prior mean of gamma_D2 parameter.}

\item{gamma_d2_sd}{Prior sd of gamma_D2 parameter.}
}
\value{
Object of class \code{\link[tibble]{tibble}}
}
\description{
Sample data from the prior predictive distributions of the two-period, single
arm Augmented Binary model, subject to chosen prior parameters.
}
\examples{
prior_predictive_augbin_2t_1a(num_samps = 1000,
                              alpha_mean = 0, alpha_sd = 1,
                              beta_mean = 0, beta_sd = 1,
                              gamma_mean = 0, gamma_sd = 1,
                              sigma_mean = 0, sigma_sd = 1,
                              omega_lkj_eta = 1,
                              alpha_d1_mean = 0, alpha_d1_sd = 1,
                              gamma_d1_mean = 0, gamma_d1_sd = 1,
                              alpha_d2_mean = 0, alpha_d2_sd = 1,
                              gamma_d2_mean = 0, gamma_d2_sd = 1)
}
\seealso{
\code{\link{stan_augbin}}
}
