% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens.slope.R
\name{sens.slope}
\alias{sens.slope}
\title{Sen's slope}
\usage{
sens.slope(x, conf.level = 0.95)
}
\arguments{
\item{x}{numeric vector or a time series object of class "ts"}

\item{conf.level}{numeric, the level of significance}
}
\value{
A list of class "htest".

\item{estimates}{numeric, Sen's slope}
\item{data.name}{character string that denotes the input data}
\item{p.value}{the p-value}
\item{statistic}{the z quantile of the standard normal distribution}
\item{null.value}{the null hypothesis}
\item{conf.int}{upper and lower confidence limit}
\item{alternative}{the alternative hypothesis}
\item{method}{character string that denotes the test}
}
\description{
Computes Sen's slope  for linear rate of change and corresponding
confidence intervalls
}
\details{
This test computes both the slope (i.e. linear rate of change) and
 confidence levels according to Sen's method. First, a set of linear slopes is
 calculated as follows:
 \deqn{d_{k} = \frac{x_j - x_i}{j - i}}{%
   d(k) = (x(j) - x(i)) / (j - i)}

 for \eqn{\left(1 \le i < j \le n \right)}{(1 <= i < j <= n)}, where d
 is the slope, x denotes the variable, n is the number of data, and i,
 j are indices.

 Sen's slope is then calculated as the median from all slopes:
 \eqn{b_{Sen} = \textnormal{median}(d_k)}{b = Median(d(k))}.

 This function also computes the upper and lower confidence limits for
 sens slope.
}
\note{
Current Version is for complete observations only.
}
\examples{
data(maxau)
sens.slope(maxau[,"s"])
mk.test(maxau[,"s"])

}
\references{
Hipel, K.W. and McLeod, A.I. (1994),
\emph{Time Series Modelling of Water Resources and Environmental Systems}. 
New York: Elsevier Science.

   Sen, P.K. (1968), Estimates of the regression coefficient based on
   Kendall's tau, \emph{Journal of the American Statistical Association} 63,
   1379--1389.
}
\keyword{nonparametric}
\keyword{ts}
\keyword{univar}
