% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylogenetic_diversity.R
\name{phylogenetic_diversity}
\alias{phylogenetic_diversity}
\title{Phylogenetic diversity at time point t}
\usage{
phylogenetic_diversity(input_obj, t = 0, extinct_tol = NULL)
}
\arguments{
\item{input_obj}{phylo object or Ltable}

\item{t}{time point at which to measure phylogenetic diversity, alternatively
a vector of time points can also be provided. Time is measured with 0 being
the present.}

\item{extinct_tol}{tolerance to determine if a lineage is extinct at time t.
Default is 1/100 * smallest branch length of the tree.}
}
\value{
phylogenetic diversity, or vector of phylogenetic diversity measures
if a vector of time points is used as input.
}
\description{
The phylogenetic diversity at time t is given by the total
branch length of the tree reconstructed up until time point t. Time is
measured increasingly, with the crown age equal to 0. Thus, the time at
the present is equal to the crown age.
}
\references{
Faith, Daniel P. "Conservation evaluation and phylogenetic
diversity." Biological conservation 61.1 (1992): 1-10.
}
