% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGroves.R
\name{plotGroves}
\alias{plotGroves}
\title{Scatterplot of groups of trees}
\usage{
plotGroves(x, groups = NULL, xax = 1, yax = 2, type = c("chull",
  "ellipse"), col.pal = funky, bg = "white", lab.show = FALSE,
  lab.col = "black", lab.cex = 1, lab.optim = TRUE, point.cex = 1,
  scree.pal = NULL, scree.size = 0.2, scree.posi = c(0.02, 0.02), ...)
}
\arguments{
\item{x}{a list returned by \code{\link{findGroves}} or a MDS with class \code{dudi}}

\item{groups}{a factor defining groups of trees}

\item{xax}{a number indicating which principal component to be used as 'x' axis}

\item{yax}{a number indicating which principal component to be used as 'y' axis}

\item{type}{a character string indicating which type of graph to use}

\item{col.pal}{a color palette to be used for the groups}

\item{bg}{the background color}

\item{lab.show}{a logical indicating whether labels should be displayed}

\item{lab.col}{a color for the labels}

\item{lab.cex}{the size of the labels}

\item{lab.optim}{a logical indicating whether label positions should be optimized to avoid overlap; better display but time-consuming for large datasets}

\item{point.cex}{the size of the points}

\item{scree.pal}{a color palette for the screeplot}

\item{scree.size}{a size factor for the screeplot, between 0 and 1}

\item{scree.posi}{either a character string or xy coordinates indicating the position of the screeplot.}

\item{...}{further arguments passed to \code{\link{s.class}}}
}
\value{
An adegraphics object (class: ADEgS)
}
\description{
This function displays the scatterplot of the Multidimensional
Scaling (MDS) output by treescape, superimposing group information
(derived by \code{\link{findGroves}}) using colors.
}
\details{
This function relies on \code{\link[adegraphics]{s.class}}
from the adegraphics package.
}
\examples{

\dontrun{
if(require("adegenet") && require("adegraphics")){
## load data
data(woodmiceTrees)

## run findGroves: treescape+clustering
res <- findGroves(woodmiceTrees, nf=5, nclust=6)

## basic plot
plotGroves(res)

## adding labels
plotGroves(res, lab.show=TRUE)

## customizing
plotGroves(res, lab.show=TRUE,
bg="black", lab.col="white", scree.size=.35)

## customizing
plotGroves(res, type="ellipse", lab.show=TRUE,
lab.optim=FALSE, scree.size=.35)

## example with no group information
plotGroves(res$treescape$pco)

## adding labels
plotGroves(res$treescape$pco, lab.show=TRUE, lab.cex=2)

}
}

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
\seealso{
\code{\link[adegraphics]{s.class}}
}

