% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeplyr_functions.R
\name{treeply}
\alias{treeply}
\alias{treeply.treedata}
\title{Run a function on the phylogeny of a \code{treedata} object}
\usage{
treeply(tdObject, ...)

\method{treeply}{treedata}(tdObject, FUN, ...)
}
\arguments{
\item{tdObject}{An object of class \code{treedata}}

\item{...}{Additional arguments}

\item{FUN}{A function that operates on an object of class 'phylo'}
}
\value{
An object of class \code{treedata}
}
\description{
Applies a function to the phylogeny in a \code{treedata} object. If the order of
tips are changed, or if tips are dropped, then the data are automatically reordered
to match the tree.
}
\examples{
data(anolis)
td <- make.treedata(anolis$phy, anolis$dat)
td2 <- treeply(td, drop.tip, 1:50)

par(mfrow=c(1,2))
plot(td$phy)
plot(td2$phy)

}
