% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distFunctions.R
\name{treeToDistMat}
\alias{treeToDistMat}
\title{Calculates the distance matrix from a list of phylo objects}
\usage{
treeToDistMat(trees, method = "logDiff", type = "real", numThreads = -1)
}
\arguments{
\item{trees}{a single phylo object or a list of phylo objects}

\item{method}{method to use when calculating coefficient distances:
\describe{
  \item{\dQuote{logDiff}}{for two coefficient matrices A and B returns sum(log(1+abs(A-B))}
  \item{\dQuote{wLogDiff}}{performs the \dQuote{logDiff} method with weights on the rows}
  \item{\dQuote{pa}}{total pairs where the coefficient is present in one matrix and absent in the other (presence-absence)}
  \item{\dQuote{ap}}{opposite comparison of pa (absence-presence)}
}}

\item{type}{one of:
\describe{
  \item{\dQuote{real}}{real coefficient polynomials}
  \item{\dQuote{complex}}{complex coefficient polynomials (real polynomials with y = 1 + i)}
  \item{\dQuote{tipLabel}}{complex coefficient polynomial that utilize binary trait tip labels on the phylo objects}
}}

\item{numThreads}{number of threads to be used, the default (-1) will use the number of cores in the machine and numThreads = 0 will only use the main thread}
}
\value{
a distance matrix
}
\description{
Calculates the distance matrix from a list of phylo objects
}
\note{
\itemize{
  \item the complex coefficient vector and the complex tip label coefficient matrix only support the \dQuote{logDiff} method
  \item \dQuote{pa} and \dQuote{ap} force symmetry in the output distance matrix
}
}
\examples{

library(treenomial)
library(ape)
# distance matrix for 10 trees of 30 tips
treeToDistMat(rmtree(10,30),method = "wLogDiff", numThreads = 0)


}
