% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeJuliaSet.R
\name{treeJuliaSet}
\alias{treeJuliaSet}
\title{Plots a Julia Set for a tree}
\usage{
treeJuliaSet(
  tree,
  pixelLength = 700,
  center = 0,
  maxZ = 2,
  maxIter = 100,
  col = c("white", colorRampPalette(c("dodgerblue4", "lightblue"))(98), "black")
)
}
\arguments{
\item{tree}{phylo object}

\item{pixelLength}{number of pixels on one side of the image}

\item{center}{complex number giving the center of the image on the complex plane}

\item{maxZ}{the max value for the real and imaginary axis}

\item{maxIter}{maximum count for iterations}

\item{col}{colours to be used for the image}
}
\description{
Finds the Julia Set for the complex polynomial of a tree and plots in a square image.
}
\examples{

library(treenomial)
library(ape)
treeJuliaSet(stree(5,type = "right"))

}
