% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getNdsSstr}
\alias{getNdsSstr}
\title{Get sister id}
\usage{
getNdsSstr(tree, ids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{nd ids}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns the ids of the sister(s) of nd ids given.
}
\details{
An error is raised if there is no sister (e.g. for the root).
 There can be more than one sister if tree is polytomous. Parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsSstr(tree, ids=tree['tips'])
}
\seealso{
\code{\link{getNdSstr}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
