% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lilhelpers.R
\name{matimage}
\alias{matimage}
\title{Plotting Matrices as Images}
\usage{
matimage(z, x = 1:dim(z)[1], y = 1:dim(z)[2], rot = TRUE, asp = 1, ...)
}
\arguments{
\item{z}{a numeric matrix.}

\item{x, y}{(optional) coordinates of the pixels.}

\item{rot}{logical. Whether to plot the matrix "the right way round" so that the pixel
position in the image corresponds to the pixel position in the matrix obtained by \code{print}.}

\item{asp}{the aspect ratio parameter of \code{\link[graphics]{image}}.}

\item{...}{further parameters passed to \code{\link[graphics]{image}}.}
}
\value{
Nothing (invisible NULL).
}
\description{
A simple wrapper to the image function with a more convenient syntax for plotting 
matrices "the right way round" as pixel images.
}
\examples{
m <- matrix(1:36,6,6)
image(z=m, col = heat.colors(36))
matimage(m, col = heat.colors(36))
}
